


=================
**Quiz - 1**


What is the fundamental objective of implementing Layer 2 data plane security mechanisms within a modern switched network architecture?

A) To defend against common local area network attacks like MAC address spoofing and VLAN manipulation. 
B) To enhance the overall efficiency and resilience of inter-VLAN routing operations and protocols. 
C) To secure the integrity and confidentiality of application-specific data streams between endpoints. 
D) To establish comprehensive end-to-end cryptographic protection for all network traffic flows.

---

**Correct Answer:** **A) To defend against common local area network attacks like MAC address spoofing and VLAN manipulation.**




**Reason:** Layer 2 data plane security controls are specifically designed to address vulnerabilities inherent to the data link layer (Layer 2) of the OSI model. These controls directly mitigate threats such as MAC address spoofing, VLAN hopping, and CAM table flooding, which operate within the local area network segment. The other options refer to different layers or broader network functions: Option B relates to Layer 3 (routing), Option C refers to application-specific security (Layer 7), and Option D describes general cryptographic protection, which is often implemented at higher layers or through specific security protocols, not solely by Layer 2 data plane controls.












=================
**Quiz - 2**







Which three mitigation techniques on a Cisco switch will protect against VLAN hopping attacks? (Choose three.)

- disabling DTP
    
- enabling port security
    
- using a dedicated 802.1Q native VLAN
    
- explicitly assigning trunk or access mode on interfaces
    
- using dynamic mode on interfaces









### Answer

The correct answers are **disabling DTP**, **using a dedicated 802.1Q native VLAN**, and **explicitly assigning trunk or access mode on interfaces**. Disabling the DTP protocol disables the interface mode autonegotiation process on the interfaces connecting to each other. Using a dedicated native VLAN on the trunk link that at the same time is not used on access interfaces, denies any frames with double tags included. Assigning the correct mode on interfaces operating as access interfaces or trunks is crucial against denying VLAN-based attacks from the neighboring devices. Port security helps against MAC spoofing and CAM flooding. Dynamic mode allows the interface to autonegotiate with the other side and set the interface mode to either access or trunk, which afterwards can be abused for initiating VLAN hopping attacks.













=================
**Quiz - 3**






Which of the following actions is the most effective in preventing double-tagging VLAN hopping attacks on a Cisco switch network?

A. Assigning all switch ports to VLAN 1 by default  
B. Disabling Dynamic Trunking Protocol (DTP) on all trunk ports  
C. Configuring a unique, dedicated native VLAN on trunk ports that is not used by any access ports  
D. Enabling trunking mode on all switch interfaces








---

**Correct Answer:**  
C. Configuring a unique, dedicated native VLAN on trunk ports that is not used by any access ports

---

**Reason:**  
Double-tagging VLAN hopping attacks exploit the native VLAN on trunk ports. By ensuring that the native VLAN is a unique VLAN not assigned to any access ports, you prevent attackers from injecting frames into the native VLAN from an access port, thereby effectively mitigating this attack method. Disabling DTP helps mitigate basic VLAN hopping attacks, but does not prevent double-tagging.













=================
**Quiz - 4**




If PortFast, BPDU Guard, and Root Guard formed a superhero team, what would their group name be?

A. The League of Loop Prevention  
B. The VLAN Avengers  
C. The Broadcast Busters  
D. The Fast, the Guard, and the Rootious





**Answer:** A. The League of Loop Prevention  
_Reason: Together, they protect your Layer 2 network from loops and attacks!_










=================
**Quiz - 5**







Which feature protects against a rogue Cisco switch to overtake the role of the root bridge in the topology?

- PortFast
    
- STP
    
- root guard
    
- BPDU guard
    






### Answer

The correct answer is **root guard**. The root guard feature of Cisco switches prevents a switch from becoming a root bridge on configured ports. The PortFast feature causes an interface that is configured as a Layer 2 access port to transition directly into the forwarding state. The BPDU guard feature disables the interface when a BPDU packet is received. The STP is a protocol that has the main goal of protecting against potential loops in a topology.












=================
**Quiz - 6**




#### What is the primary purpose of enabling port security on a switch port?

A. To allow multiple VLANs on a single port  
B. To limit and control which MAC addresses can send frames through the port  
C. To enable trunking between switches  
D. To increase the speed of the port






**Correct Answer:** B  
**Reason:** Port security restricts switch port access to specific MAC addresses, helping prevent unauthorized network access.
















=================
**Quiz - 7**








Which port security violation mode will place the port in an error-disabled state and require manual intervention to recover?

A. Protect  
B. Restrict  
C. Shutdown  
D. Notify






**Correct Answer:** C  
**Reason:** Shutdown mode disables the port upon a violation and requires administrative action to restore it.







=================
**Quiz - 8**


What is the effect of configuring the “sticky” MAC address feature on a port?

A. The port will only allow static MAC addresses  
B. The port will dynamically learn MAC addresses and save them as if they were statically configured  
C. The port will allow any MAC address  
D. The port will be reset after every violation








**Correct Answer:** B  
**Reason:** Sticky MAC addresses are dynamically learned and stored in the running configuration as static entries.









=================
**Quiz - 9**






A network administrator wants to prevent MAC flooding and MAC spoofing attacks on a switch port while allowing a PC and an IP phone to connect. Which configuration is most appropriate for this scenario?

A. Set port security to allow only one static MAC address and use shutdown violation mode  
B. Set port security to allow two sticky MAC addresses and use restrict violation mode  
C. Set port security to allow unlimited dynamically learned MAC addresses and use protect violation mode  
D. Disable port security and rely on CAM table aging









---

**Correct Answer:**  
B. Set port security to allow two sticky MAC addresses and use restrict violation mode

---

**Reason:**  
Allowing two sticky MAC addresses enables both the PC and IP phone to connect, while restrict violation mode denies offending frames, logs the violation, and keeps the port active. This configuration is scalable, secure, and suitable for environments where two devices share a port, such as with a PC connected through an IP phone.















=================
**Quiz - 10**





#### What happens when the number of learned MAC addresses on a port exceeds the configured maximum?

A. The port ignores extra MAC addresses  
B. The configured violation action is triggered (protect, restrict, or shutdown)  
C. The switch disables all ports  
D. The switch logs off all users







**Correct Answer:** B  
**Reason:** Exceeding the MAC address limit triggers the configured violation action.
















=================
**Quiz - 11**





Which port security violation mode drops offending frames but does not increment the violation counter or send notifications?

A. Protect  
B. Restrict  
C. Shutdown  
D. Alert




**Correct Answer:** A  
**Reason:** Protect mode simply drops offending frames without any logging or counter increment.


















=================
**Quiz - 12**





#### Which command would you use to verify the port security status and violations on a specific interface?

A. show interface status  
B. show port-security interface [interface-id]  
C. show mac-address-table  
D. show running-config





**Correct Answer:** B  
**Reason:** The `show port-security interface` command displays the port security configuration and violation information for a specific interface.

















=================
**Quiz - 13**





```none
Switch# show port-security interface FastEthernet 0/1

Port Security              : Enabled
Port Status                : Secure-shutdown
Violation Mode             : Shutdown
Aging Time                 : 120 mins
Aging Type                 : Absolute
SecureStatic Address Aging : Disabled
Maximum MAC Addresses      : 2
Total MAC Addresses        : 2
Configured MAC Addresses   : 0
Sticky MAC Addresses       : 2
Last Source Address        : 00A1.B2C3.D4E5
Security Violation Count   : 1
```

---

### Explanation of Each Line

- **Port Security : Enabled**  
    Port security is currently active on this interface. The switch will enforce port security policies.
    
- **Port Status : Secure-shutdown**  
    The port is shut down due to a security violation. Administrative intervention is required to re-enable it.
    
- **Violation Mode : Shutdown**  
    The action taken when a violation occurs is to shut down the port (default mode). The port becomes error-disabled.
    
- **Aging Time : 120 mins**  
    Dynamically learned (sticky) MAC addresses will be removed after 120 minutes of inactivity.
    
- **Aging Type : Absolute**  
    The aging timer for MAC addresses is absolute, meaning it removes the address after the set time, regardless of activity.
    
- **SecureStatic Address Aging : Disabled**  
    Aging is not applied to statically configured secure MAC addresses; these stay in the table unless manually removed.
    
- **Maximum MAC Addresses : 2**  
    Only two MAC addresses are permitted to be learned or configured on this port.
    
- **Total MAC Addresses : 2**  
    There are currently two MAC addresses (static or sticky) learned and associated with this port.
    
- **Configured MAC Addresses : 0**  
    No MAC addresses were manually configured; all allowed addresses are learned dynamically.
    
- **Sticky MAC Addresses : 2**  
    Two MAC addresses have been dynamically learned and converted to sticky addresses, which are treated as if they were statically configured.
    
- **Last Source Address : 00A1.B2C3.D4E5**  
    This is the MAC address that most recently caused a security violation on the port.
    
- **Security Violation Count : 1**  
    Indicates the port has experienced one security violation since the last reset or port re-enablement.















=================
**Quiz - 14**






#### What is the primary purpose of implementing Private VLANs (PVLANs) in a switched network?

A. To allow Layer 3 routing between all devices on the same VLAN  
B. To provide Layer 2 isolation between devices within the same VLAN  
C. To reduce the number of trunk ports required  
D. To enable multicast traffic across all VLANs







**Correct Answer:** B  
**Reason:** PVLANs provide Layer 2 isolation, enabling devices on the same VLAN to be segmented for security and control.















=================
**Quiz - 15**








#### In PVLAN terminology, what is the primary VLAN?

A. The VLAN used for isolated communication only  
B. The VLAN that hosts the Layer 3 subnet and associates with secondary VLANs  
C. The VLAN that carries trunked traffic between switches  
D. The VLAN for community ports only






**Correct Answer:** B  
**Reason:** The primary VLAN is the main VLAN for the subnet and is associated with secondary VLANs.










=================
**Quiz - 16**


In a Private VLAN (PVLAN) configuration, which statement best describes the communication capabilities of isolated, community, and promiscuous ports?

A. Isolated ports can communicate with other isolated ports and promiscuous ports; community ports can communicate only with promiscuous ports; promiscuous ports can communicate with all port types.

B. Isolated ports can only communicate with promiscuous ports; community ports can communicate with other community ports in the same VLAN and promiscuous ports; promiscuous ports can communicate with all port types.

C. Isolated ports can communicate with all ports; community ports can communicate with isolated ports only; promiscuous ports can communicate with other promiscuous ports only.

D. All port types can communicate freely with each other within the same primary VLAN.








---

**Correct Answer:**  
**B. Isolated ports can only communicate with promiscuous ports; community ports can communicate with other community ports in the same VLAN and promiscuous ports; promiscuous ports can communicate with all port types.**

---

**Reason:**

- **Isolated ports** are strictly limited and can only send traffic to **promiscuous ports** (typically the default gateway).
- **Community ports** can communicate with other ports in the same community VLAN and with promiscuous ports, but not with isolated ports or other communities.
- **Promiscuous ports** have no restriction and can communicate with all other port types within the PVLAN.  
    This structure enforces Layer 2 isolation while allowing controlled access through the promiscuous port (usually a router or firewall).









=================
**Quiz - 17**






You are configuring a Private VLAN (PVLAN) on a Cisco switch for a DMZ segment. You have four devices connected as follows:

- **Device A:** Connected to an isolated port
- **Device B:** Connected to a community port (community VLAN 200)
- **Device C:** Connected to a promiscuous port (primary VLAN 100, connected to the default gateway)
- **Device D:** Connected to another community port (community VLAN 200)

**Question:**  
Which of the following communications are allowed at Layer 2 in this PVLAN setup? (Select all that apply.)

A. Device A can communicate with Device B  
B. Device B can communicate with Device D  
C. Device A can communicate with Device C  
D. Device B can communicate with Device C

---

### Correct Answers

**B. Device B can communicate with Device D**  
**C. Device A can communicate with Device C**  
**D. Device B can communicate with Device C**

---

### Detailed Reasoning

#### **Isolated Port (Device A)**

- An isolated port can **only** communicate with promiscuous ports.
- It cannot talk to other isolated ports or any community ports (even in the same or different community VLANs).
- **Device A → Device B:** **NOT allowed** (B is a community port; isolated ports cannot communicate with community ports).
- **Device A → Device C:** **Allowed** (C is a promiscuous port, which is the only type an isolated port can reach).

#### **Community Port (Device B & Device D)**

- Community ports can communicate with:
    - Other ports in the **same community VLAN**
    - Promiscuous ports
- They **cannot** communicate with isolated ports or community ports in **other** community VLANs.
- **Device B → Device D:** **Allowed** (Both are community ports in VLAN 200).
- **Device B → Device C:** **Allowed** (C is a promiscuous port).
- **Device B → Device A:** **NOT allowed** (Cannot reach isolated ports).

#### **Promiscuous Port (Device C)**

- Promiscuous ports can communicate with **all** port types (isolated, community, and other promiscuous ports).
- Both Device A (isolated) and Device B or D (community) can communicate with Device C.

















=================
**Quiz - 18**









When configuring DHCP snooping, which ports should be configured as untrusted ports?

- all access ports
    
- all interswitch trunk ports
    
- all ports that are connecting toward the DHCP server
    
- all access ports, except the port to which the DHCP server is directly connected
    







### Answer

The correct answer is **all access ports, except the port to which the DHCP server is directly connected**. All access ports should be labeled as untrusted, except the port to which the DHCP server is directly connected. All interswitch ports and ports that are pointing toward the DHCP server should be labeled as trusted.






=================
**Quiz - 19**




A network administrator is implementing DHCP snooping on a Cisco switch to protect against DHCP spoofing and starvation attacks. Which of the following configurations BEST prevents DHCP spoofing attacks while allowing legitimate DHCP server traffic to reach clients in VLAN 100?

A. Enable DHCP snooping globally, designate all switch ports as trusted, and set the DHCP rate limit to 5 packets per second on all interfaces.

B. Enable DHCP snooping globally and for VLAN 100, designate only the interfaces connected to legitimate DHCP servers as trusted, and configure all other ports as untrusted with port security and rate limiting.

C. Enable DHCP snooping only on the ports connected to end-user devices, with all ports set to untrusted, and configure port security with a maximum of 10 MAC addresses.

D. Assign static IP addresses to all end-user devices and disable DHCP snooping on the switch.








**Correct Answer:**  
B. Enable DHCP snooping globally and for VLAN 100, designate only the interfaces connected to legitimate DHCP servers as trusted, and configure all other ports as untrusted with port security and rate limiting.


**Reason:**  
To effectively prevent DHCP spoofing attacks, you must enable DHCP snooping globally and on the relevant VLAN(s), then explicitly trust only those switch ports that connect to legitimate DHCP servers. All other ports (such as access ports to clients) must be untrusted to block unauthorized DHCP responses. Adding port security and rate limiting on untrusted ports also helps mitigate DHCP starvation attacks.






=================
**Quiz - 20**




What do you see on the screen right now ? 



![[Pasted image 20250811083134.png]]









**Answer** - **arp table** (maps IP to mac address)









=================
**Quiz - 21**




An Intern network engineer asks: “If all traffic is routed using IP addresses, why does a device need to map an IP address to a MAC address with ARP before sending a packet on a local subnet?”

Which explanation **BEST** clarifies the purpose of IP-to-MAC address mapping in an Ethernet network?

A. IP addresses are only used for routing within the local subnet; MAC addresses are only needed for devices outside the subnet.

B. When sending data over Ethernet, frames must have the destination device’s MAC address in the Layer 2 header, so ARP is used to map the destination IP address to its MAC address for proper delivery on the local network segment.

C. MAC addresses are used to encrypt data, so mapping IP to MAC ensures data confidentiality.

D. The mapping is only required for wireless networks, as wired networks do not use MAC addresses in communication.







---

**Correct Answer:**  
B. When sending data over Ethernet, frames must have the destination device’s MAC address in the Layer 2 header, so ARP is used to map the destination IP address to its MAC address for proper delivery on the local network segment.

**Reason:**  
Even though IP addresses are used to logically identify source and destination hosts, Ethernet devices deliver data using MAC addresses in the Layer 2 header. ARP translates IP addresses to MAC addresses so that packets can be encapsulated in Ethernet frames for delivery on the local network.







=================
**Quiz - 22**





An administrator wants to protect a Layer 2 network against ARP spoofing attacks. Which configuration BEST ensures only legitimate ARP packets are relayed on access switch ports while allowing valid interswitch ARP traffic?

A. Enable Dynamic ARP Inspection (DAI) on the relevant VLANs, configure access ports as untrusted, interswitch links as trusted, and use DHCP snooping or ARP ACLs for validation.

B. Enable Dynamic ARP Inspection on all ports and set every switch port as trusted by default.

C. Configure static ARP entries for all end-user devices and disable ARP on access ports.

D. Implement port security with a MAC address limit on all ports, without enabling DAI or DHCP snooping.









---

**Correct Answer:**  
A. Enable Dynamic ARP Inspection (DAI) on the relevant VLANs, configure access ports as untrusted, interswitch links as trusted, and use DHCP snooping or ARP ACLs for validation.

**Reason:**  
DAI protects against ARP spoofing by validating ARP packets on untrusted ports, using DHCP snooping or ARP ACLs for known MAC-to-IP bindings. Trusted ports (such as interswitch links) bypass ARP checks, ensuring efficient and secure network operation.









=================
**Quiz - 23**







A network engineer needs to prevent a broadcast storm from consuming all available bandwidth on a Cisco switch port. The engineer wants the port to stop forwarding traffic when usage exceeds 60% of the port’s bandwidth, and to resume normal operation only when usage drops below 50%. Which configuration **BEST** achieves this protection?



A. Enable storm control on the port, set the broadcast level rising threshold to 60% and the falling threshold to 50%, and configure the action to shutdown.

B. Enable port security, set the maximum MAC addresses to 2, and configure violation mode to restrict.

C. Enable storm control globally, set both the rising and falling thresholds to 100%, and configure the action to trap.

D. Enable storm control on the port, set the broadcast level falling threshold to 60% and the falling rising to 50%, and configure the action to shutdown.










---

**Correct Answer:**  
A. Enable storm control on the port, set the broadcast level rising threshold to 60% and the falling threshold to 50%, and configure the action to shutdown.

**Reason:**  
Storm control allows you to set precise rising and falling thresholds for broadcast, multicast, or unicast traffic as a percentage of interface bandwidth. Setting the rising threshold to 60% and the falling threshold to 50%, along with the shutdown action, will automatically error-disable the port when a storm is detected and resume forwarding when conditions return to normal. This directly addresses the scenario described.








=================
**Quiz - 24**



A network administrator needs to secure data exchanged between wired devices on the LAN and ensure that even ARP and DHCP traffic cannot be read or altered over the wire. Which of the following features BEST provides Layer 2 encryption and authentication for this scenario?

A. Port Security with sticky MAC addresses  
B. Dynamic ARP Inspection (DAI)  
C. MACsec (IEEE 802.1AE) with Cisco TrustSec integration  
D. Access Control Lists (ACLs) on switch ports







---

**Correct Answer:**  
C. MACsec (IEEE 802.1AE) with Cisco TrustSec integration

**Reason:**  
MACsec (IEEE 802.1AE) encrypts and authenticates all Layer 2 frames—including ARP, DHCP, and other protocols between MACsec-capable devices, providing confidentiality and integrity on wired LANs. Cisco TrustSec further integrates MACsec with features like Security Group Tags (SGTs) for end-to-end secure access management. Other options do not provide encryption or comprehensive Layer 2 security.











=================
**Quiz - 25**




Which statement BEST describes the role of Cisco TrustSec and the Security Association Protocol (SAP) in enterprise network security?

A. Cisco TrustSec provides dynamic, identity-based network segmentation and can use SAP to negotiate authentication and encryption between network devices at Layer 2.  
B. Cisco TrustSec is a wireless-only protocol that prevents rogue access points, and SAP is used for automatic VLAN assignment.  
C. SAP is a protocol for encrypting application-layer data, while TrustSec is limited to physical port security.  
D. Cisco TrustSec creates static access control lists (ACLs) for all VLANs, and SAP is used for DHCP snooping.







---

**Correct Answer:**  
A. Cisco TrustSec provides dynamic, identity-based network segmentation and can use SAP to negotiate authentication and encryption between network devices at Layer 2.

**Reason:**  
Cisco TrustSec enables scalable, identity-based access control and segmentation. SAP is used within TrustSec to establish secure, authenticated, and optionally encrypted Layer 2 connections between network devices. Other options either describe unrelated features or incorrect uses of TrustSec and SAP.






=========

